/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.parse.txt.mdfe.v2;

import br.com.ophos.parse.ParseException;
import br.com.ophos.parse.txt.mdfe.v2.ParseTXTEnvioMDFEv200;
import br.com.ophos.parse.util.Scanner;
import br.com.ophos.util.nfe.Util;
import br.com.ophos.xml.mdfe.envio.InfoAdicional;
import br.com.ophos.xml.mdfe.envio.Totais;

public class ParseTXTEnvioMDFEv202
extends ParseTXTEnvioMDFEv200 {
    private static ParseTXTEnvioMDFEv202 instance;

    public static ParseTXTEnvioMDFEv202 getInstance() {
        if (instance == null) {
            instance = new ParseTXTEnvioMDFEv202();
        }
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dadosManifesto(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 15) {
                throw new ParseException("A linha 000 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 15 campos.");
            }
            while (true) {
                String participaCargaVerde;
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                this.obj.setNumero(Integer.parseInt(scanner.next()));
                this.obj.setSerie(Short.parseShort(scanner.next()));
                this.obj.setDataEmissao(Util.StringToDateTime(scanner.next()));
                this.obj.setTipoModal(scanner.next());
                this.obj.setUfIni(scanner.next());
                this.obj.setUfFim(scanner.next());
                this.obj.setNrReferencia(scanner.next());
                if (this.obj.getTotais() == null) {
                    this.obj.setTotais(new Totais());
                }
                this.obj.getTotais().setPesoBruto(Util.StringToDouble(scanner.next(), Util.ST_FMT_QUATRO_DECIMAIS));
                this.obj.getTotais().setUnidadeMedida(scanner.next());
                this.obj.getTotais().setValorTotalCarga(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                if (this.obj.getInfoAdicional() == null) {
                    this.obj.setInfoAdicional(new InfoAdicional());
                }
                this.obj.getInfoAdicional().setInfoContribuinte(scanner.next());
                this.obj.getInfoAdicional().setInfoFisco(scanner.next());
                this.obj.setInicioViagem(Util.StringToDateTime(scanner.next()));
                String tipoTransportador = scanner.next();
                if (tipoTransportador != null && !tipoTransportador.trim().isEmpty()) {
                    this.obj.setTipoTransportador(tipoTransportador);
                }
                if ((participaCargaVerde = scanner.next()) == null || !"1".equals(participaCargaVerde)) continue;
                this.obj.setParticipaCanalVerde(true);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 000: " + ex.getMessage());
        }
    }
}

