/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.parse.txt.mdfe.v2;

import br.com.ophos.parse.ParseException;
import br.com.ophos.parse.txt.mdfe.v2.ParseTXTEnvioMDFEv203;
import br.com.ophos.parse.util.Scanner;
import br.com.ophos.util.nfe.Util;
import br.com.ophos.xml.mdfe.envio.Seguro;

public class ParseTXTEnvioMDFEv204
extends ParseTXTEnvioMDFEv203 {
    private static ParseTXTEnvioMDFEv204 instance;

    public static ParseTXTEnvioMDFEv204 getInstance() {
        if (instance == null) {
            instance = new ParseTXTEnvioMDFEv204();
        }
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dadosSeguro(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 7) {
                throw new ParseException("A linha 018 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 7 campos.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                Seguro seguro = new Seguro();
                int id = Integer.parseInt(scanner.next());
                String responsavel = scanner.next();
                String cnpjCpf = scanner.next();
                String nomeSeguradora = scanner.next();
                String cnpjSeguradora = scanner.next();
                String numeroApolice = scanner.next();
                String declararMdfe = scanner.next();
                seguro.setResponsavelSeguro(responsavel);
                seguro.setCnpjCpf(cnpjCpf);
                if (nomeSeguradora != null && !nomeSeguradora.trim().isEmpty()) {
                    seguro.setNomeSeguradora(nomeSeguradora);
                }
                if (cnpjSeguradora != null && !cnpjSeguradora.trim().isEmpty()) {
                    seguro.setCnpjSeguradora(cnpjSeguradora);
                }
                if (numeroApolice != null && !numeroApolice.trim().isEmpty()) {
                    seguro.setNumeroApolice(numeroApolice);
                }
                if (declararMdfe != null && !declararMdfe.trim().isEmpty()) {
                    seguro.setDeclararMdfe("1".equals(declararMdfe) ? Boolean.TRUE : Boolean.FALSE);
                }
                this.obj.getSeguro().add(seguro);
                this.mapSeguro.put(id, seguro);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 018: " + ex.getMessage());
        }
    }
}

