/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.parse.txt.mdfe.v2;

import br.com.ophos.parse.ParseException;
import br.com.ophos.parse.txt.mdfe.v2.ParseTXTEnvioMDFEv204;
import br.com.ophos.parse.util.Scanner;
import br.com.ophos.util.nfe.Util;
import br.com.ophos.xml.mdfe.envio.InfoAdicional;
import br.com.ophos.xml.mdfe.envio.InfoContratante;
import br.com.ophos.xml.mdfe.envio.InfoPagamento;
import br.com.ophos.xml.mdfe.envio.InfoProduto;
import br.com.ophos.xml.mdfe.envio.Totais;

public class ParseTXTEnvioMDFEv205
extends ParseTXTEnvioMDFEv204 {
    private static ParseTXTEnvioMDFEv205 instance;

    public static ParseTXTEnvioMDFEv205 getInstance() {
        if (instance == null) {
            instance = new ParseTXTEnvioMDFEv205();
        }
        return instance;
    }

    @Override
    protected void lerLinhaManifesto(String linha) throws ParseException {
        Integer id = Integer.parseInt(linha.substring(1, 3));
        switch (id) {
            case 0: {
                this.dadosManifesto(linha);
                break;
            }
            case 1: {
                this.dadosEmitente(linha);
                break;
            }
            case 2: {
                this.dadosRodoviario(linha);
                break;
            }
            case 3: {
                this.dadosVeiculo(linha);
                break;
            }
            case 4: {
                this.dadosReboque(linha);
                break;
            }
            case 5: {
                this.dadosValePedagio(linha);
                break;
            }
            case 6: {
                this.dadosMotorista(linha);
                break;
            }
            case 7: {
                this.dadosLacreRodoviario(linha);
                break;
            }
            case 8: {
                this.dadosContratanteRodoviario(linha);
                break;
            }
            case 9: {
                this.dadosCarregamento(linha);
                break;
            }
            case 10: {
                this.dadosDescarregamento(linha);
                break;
            }
            case 11: {
                this.dadosDocumentos(linha);
                break;
            }
            case 12: {
                this.dadosLacres(linha);
                break;
            }
            case 13: {
                this.dadosUnidadesTransporte(linha);
                break;
            }
            case 14: {
                this.dadosUnidadesCarga(linha);
                break;
            }
            case 15: {
                this.dadosLacresTransporte(linha);
                break;
            }
            case 16: {
                this.dadosLacresCarga(linha);
                break;
            }
            case 17: {
                this.dadosProdutoPerigoso(linha);
                break;
            }
            case 18: {
                this.dadosSeguro(linha);
                break;
            }
            case 19: {
                this.dadosAverbacaoSeguro(linha);
                break;
            }
            case 20: {
                this.dadosAutorizacaoXML(linha);
                break;
            }
            case 21: {
                this.dadosPercurso(linha);
                break;
            }
            case 22: {
                this.dadosInfoContribuinte(linha);
                break;
            }
            case 23: {
                this.dadosCiot(linha);
                break;
            }
            case 24: {
                this.dadosLocalizacao(linha);
                break;
            }
            case 25: {
                this.dadosPagamento(linha);
                break;
            }
            case 26: {
                this.dadosComponenteFrete(linha);
                break;
            }
            case 27: {
                this.dadosParcelaFrete(linha);
                break;
            }
            default: {
                throw new ParseException("O identificador '" + String.valueOf(id) + "'da linha informado n\u00e3o foi encontrado.");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dadosManifesto(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 19) {
                throw new ParseException("A linha 000 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 19 campos.");
            }
            while (true) {
                String participaCargaVerde;
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                this.obj.setNumero(Integer.parseInt(scanner.next()));
                this.obj.setSerie(Short.parseShort(scanner.next()));
                this.obj.setDataEmissao(Util.StringToDateTime(scanner.next()));
                this.obj.setTipoModal(scanner.next());
                this.obj.setUfIni(scanner.next());
                this.obj.setUfFim(scanner.next());
                this.obj.setNrReferencia(scanner.next());
                if (this.obj.getTotais() == null) {
                    this.obj.setTotais(new Totais());
                }
                this.obj.getTotais().setPesoBruto(Util.StringToDouble(scanner.next(), Util.ST_FMT_QUATRO_DECIMAIS));
                this.obj.getTotais().setUnidadeMedida(scanner.next());
                this.obj.getTotais().setValorTotalCarga(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                String tipoCarga = scanner.next();
                String produto = scanner.next();
                String ean = scanner.next();
                String ncm = scanner.next();
                if (!(tipoCarga.isEmpty() && produto.isEmpty() && ean.isEmpty() && ncm.isEmpty())) {
                    InfoProduto prod = new InfoProduto();
                    prod.setTipoCarga(br.com.ophos.util.Util.checkIsNullEmpty(tipoCarga));
                    prod.setProduto(br.com.ophos.util.Util.checkIsNullEmpty(produto));
                    prod.setEan(br.com.ophos.util.Util.checkIsNullEmpty(ean));
                    prod.setNcm(br.com.ophos.util.Util.checkIsNullEmpty(ncm));
                    this.obj.setInfoProduto(prod);
                }
                if (this.obj.getInfoAdicional() == null) {
                    this.obj.setInfoAdicional(new InfoAdicional());
                }
                this.obj.getInfoAdicional().setInfoContribuinte(scanner.next());
                this.obj.getInfoAdicional().setInfoFisco(scanner.next());
                this.obj.setInicioViagem(Util.StringToDateTime(scanner.next()));
                String tipoTransportador = scanner.next();
                if (tipoTransportador != null && !tipoTransportador.trim().isEmpty()) {
                    this.obj.setTipoTransportador(tipoTransportador);
                }
                if ((participaCargaVerde = scanner.next()) == null || !"1".equals(participaCargaVerde)) continue;
                this.obj.setParticipaCanalVerde(true);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 000: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dadosContratanteRodoviario(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 2) {
                throw new ParseException("A linha 008 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 2 campo.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                InfoContratante info = new InfoContratante();
                info.setCnpjCpf(scanner.next());
                info.setNome(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                this.obj.getModal().getRodoviario().getInfoContratante().add(info);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 008: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dadosLocalizacao(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 6) {
                throw new ParseException("A linha 024 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 6 campo.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                InfoProduto.InfoLotacao lotacao = new InfoProduto.InfoLotacao();
                InfoProduto.InfoLocalizacao carregamento = new InfoProduto.InfoLocalizacao();
                carregamento.setCep(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                carregamento.setLatitude(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                carregamento.setLongitude(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                lotacao.setCarregamento(carregamento);
                InfoProduto.InfoLocalizacao descarregamento = new InfoProduto.InfoLocalizacao();
                descarregamento.setCep(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                descarregamento.setLatitude(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                descarregamento.setLongitude(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                lotacao.setDescarregamento(descarregamento);
                this.obj.getInfoProduto().setInfoLotacao(lotacao);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 024: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dadosPagamento(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 8) {
                throw new ParseException("A linha 025 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 8 campo.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                InfoPagamento pag = new InfoPagamento();
                pag.setId(scanner.next());
                pag.setCnpjCpf(scanner.next());
                pag.setNome(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                pag.setValorContrato(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                pag.setFormaPagamento(scanner.next());
                pag.setBanco(new InfoPagamento.InfoBanco());
                pag.getBanco().setBanco(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                pag.getBanco().setAgencia(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                pag.getBanco().setCnpjIpef(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                this.obj.getModal().getRodoviario().getInfoPagamento().add(pag);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 025: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dadosComponenteFrete(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 4) {
                throw new ParseException("A linha 026 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 4 campo.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                InfoPagamento pgto = this.getPgto(scanner.next());
                InfoPagamento.Componente comp = new InfoPagamento.Componente();
                comp.setTipo(scanner.next());
                comp.setDescricao(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                comp.setValor(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                pgto.getComponentes().add(comp);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 026: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dadosParcelaFrete(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 4) {
                throw new ParseException("A linha 027 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 4 campo.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                InfoPagamento pgto = this.getPgto(scanner.next());
                InfoPagamento.InfoParcela parcela = new InfoPagamento.InfoParcela();
                parcela.setNumero(scanner.next());
                parcela.setVencimento(Util.StringToXMLCalendar(scanner.next()));
                parcela.setValor(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                pgto.getParcelas().add(parcela);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 027: " + ex.getMessage());
        }
    }

    protected InfoPagamento getPgto(String id) throws ParseException {
        for (InfoPagamento o : this.obj.getModal().getRodoviario().getInfoPagamento()) {
            if (!id.equals(o.getId())) continue;
            return o;
        }
        throw new ParseException("O identificador do pagamento informado n\u00e3o foi localizado.");
    }
}

