/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.parse.txt.nfse.v1;

import br.com.ophos.parse.ParseException;
import br.com.ophos.parse.txt.nfse.v1.ParseTXTEnvioNFSEv100;
import br.com.ophos.util.nfe.Util;
import br.com.ophos.xml.nfse.envio.v100.Prestador;
import br.com.ophos.xml.nfse.envio.v100.Servico;
import br.com.ophos.xml.nfse.envio.v100.Tomador;
import java.util.Scanner;

public class ParseTXTEnvioNFSEV101
extends ParseTXTEnvioNFSEv100 {
    private static ParseTXTEnvioNFSEV101 instance;

    public static ParseTXTEnvioNFSEV101 getInstance() {
        if (instance == null) {
            instance = new ParseTXTEnvioNFSEV101();
        }
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dadosPrestador(String linha) throws ParseException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Scanner scanner = new Scanner(linha);){
                scanner.useDelimiter("\\|");
                Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
                Integer qtdEsperada = 5;
                if (qtdCampos != qtdEsperada) {
                    throw new ParseException("A linha 001 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + String.valueOf(qtdEsperada) + " campos.");
                }
                while (true) {
                    if (!scanner.hasNext()) {
                        return;
                    }
                    scanner.next();
                    if (this.obj.getPrestador() == null) {
                        this.obj.setPrestador(new Prestador());
                    }
                    this.obj.getPrestador().setCnpj(scanner.next());
                    this.obj.getPrestador().setInscricaoMunicipal(scanner.next());
                    String regimeEspecial = scanner.next();
                    if (regimeEspecial != null && !regimeEspecial.trim().isEmpty()) {
                        this.obj.getPrestador().setRegimeEspecial(Integer.parseInt(regimeEspecial));
                    }
                    this.obj.getPrestador().setOptanteSimplesNacional(Integer.parseInt(scanner.next()));
                    this.obj.getPrestador().setIncentivadorCultural(Integer.parseInt(scanner.next()));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (ParseException | NumberFormatException ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 001: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dadosTomador(String linha) throws ParseException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Scanner scanner = new Scanner(linha);){
                scanner.useDelimiter("\\|");
                Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
                Integer qtdEsperada = 13;
                if (qtdCampos != qtdEsperada) {
                    throw new ParseException("A linha 002 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + String.valueOf(qtdEsperada) + " campos.");
                }
                while (true) {
                    if (!scanner.hasNext()) {
                        return;
                    }
                    scanner.next();
                    if (this.obj.getTomador() == null) {
                        this.obj.setTomador(new Tomador());
                    }
                    String cpfCnpj = scanner.next();
                    String inscricaoMunicipal = scanner.next();
                    String nome = scanner.next();
                    String logradouro = scanner.next();
                    String numero = scanner.next();
                    String complemento = scanner.next();
                    String bairro = scanner.next();
                    String municipio = scanner.next();
                    String numeroIBGE = scanner.next();
                    String uf = scanner.next();
                    String cep = scanner.next();
                    String telefone = scanner.next();
                    String email = scanner.next();
                    this.obj.getTomador().setCpfCnpj(cpfCnpj);
                    if (inscricaoMunicipal != null && !inscricaoMunicipal.trim().isEmpty()) {
                        this.obj.getTomador().setInscricaoMunicipal(inscricaoMunicipal);
                    }
                    this.obj.getTomador().setNome(nome);
                    this.obj.getTomador().setLogradouro(logradouro);
                    this.obj.getTomador().setNumero(numero);
                    if (complemento != null && !complemento.trim().isEmpty()) {
                        this.obj.getTomador().setComplemento(complemento);
                    }
                    this.obj.getTomador().setBairro(bairro);
                    this.obj.getTomador().setMunicipio(municipio);
                    this.obj.getTomador().setNrIbgeMunicipio(numeroIBGE);
                    this.obj.getTomador().setUf(uf);
                    this.obj.getTomador().setCep(cep);
                    if (telefone != null && !telefone.trim().isEmpty()) {
                        this.obj.getTomador().setTelefone(telefone);
                    }
                    if (email == null || email.trim().isEmpty()) continue;
                    this.obj.getTomador().setEmail(email);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 002: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dadosServico(String linha) throws ParseException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Scanner scanner = new Scanner(linha);){
                scanner.useDelimiter("\\|");
                Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
                Integer qtdEsperada = 7;
                if (qtdCampos != qtdEsperada) {
                    throw new ParseException("A linha 003 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + String.valueOf(qtdEsperada) + " campos.");
                }
                while (true) {
                    String codigoTributacao;
                    if (!scanner.hasNext()) {
                        return;
                    }
                    scanner.next();
                    if (this.obj.getServico() == null) {
                        this.obj.setServico(new Servico());
                    }
                    this.obj.getServico().setCodigoServico(scanner.next());
                    String cnae = scanner.next();
                    if (cnae != null && !cnae.trim().isEmpty()) {
                        this.obj.getServico().setCodigoCnae(cnae);
                    }
                    if ((codigoTributacao = scanner.next()) != null && !codigoTributacao.trim().isEmpty()) {
                        this.obj.getServico().setCodigoTributacaoMunicipio(codigoTributacao);
                    }
                    this.obj.getServico().setDescricao(scanner.next());
                    this.obj.getServico().setMunicipio(scanner.next());
                    this.obj.getServico().setNrIbgeMunicipio(scanner.next());
                    this.obj.getServico().setUf(scanner.next());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 003: " + ex.getMessage());
        }
    }
}

