/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.sign;

import br.com.ophos.sign.AssinaturaException;
import br.com.ophos.sign.ParametroAssinatura;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AssinarXML {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private ParametroAssinatura param = null;
    private PrivateKey chavePrivada = null;
    private X509Certificate cert = null;
    private boolean omitirDeclaracao = true;
    private String digestValue = null;

    public synchronized String assinar(Document doc, String ref, boolean omitirDeclaracao) throws AssinaturaException {
        try {
            this.setOmitirDeclaracao(omitirDeclaracao);
            this.logger.fine("Obtendo Chaves");
            this.obterCertificadoDigital();
            this.logger.fine("Gerando assinatura");
            StringWriter fos = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer trans = tf.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("standalone", "yes");
            trans.transform(new DOMSource(doc), new StreamResult(fos));
            this.logger.fine("Documento a assinar = " + fos.toString());
            return this.gerarAssinatura(fos.toString(), ref, null);
        }
        catch (Exception e) {
            throw new AssinaturaException("Ocorreu um erro ao assinar o XML." + e.getMessage());
        }
    }

    public synchronized String assinar(String doc, String ref, boolean omitirDeclaracao) throws AssinaturaException {
        try {
            this.setOmitirDeclaracao(omitirDeclaracao);
            this.logger.fine("Obtendo Chaves");
            this.obterCertificadoDigital();
            this.logger.fine("Gerando assinatura");
            return this.gerarAssinatura(doc, ref, null);
        }
        catch (Exception e) {
            throw new AssinaturaException("Ocorreu um erro ao assinar o XML." + e.getMessage());
        }
    }

    public synchronized String assinar(Document doc, String ref, String refSign, boolean omitirDeclaracao) throws AssinaturaException {
        try {
            this.setOmitirDeclaracao(omitirDeclaracao);
            this.logger.fine("Obtendo Chaves");
            this.obterCertificadoDigital();
            this.logger.fine("Gerando assinatura");
            StringWriter fos = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer trans = tf.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("standalone", "yes");
            trans.transform(new DOMSource(doc), new StreamResult(fos));
            this.logger.fine("Documento a assinar = " + fos.toString());
            return this.gerarAssinatura(fos.toString(), ref, refSign);
        }
        catch (Exception e) {
            throw new AssinaturaException("Ocorreu um erro ao assinar o XML." + e.getMessage());
        }
    }

    public synchronized void obterCertificadoDigital() throws Exception {
        try {
            KeyStore ks = null;
            String pass = this.getParam().getSenhaCert();
            switch (this.getParam().getLocalChave()) {
                case ARQUIVO_JKS: {
                    this.logger.fine("Chave Local");
                    ks = KeyStore.getInstance("JKS");
                    FileInputStream in = new FileInputStream(this.getParam().getPathChave());
                    ks.load(in, pass.toCharArray());
                    in.close();
                    break;
                }
                case HSM_TRUE_ACCESS: {
                    this.logger.fine("Chave True Acess");
                    break;
                }
                case SMARTCARD: {
                    this.logger.fine("Chave SmartCard");
                    ks = KeyStore.getInstance("PKCS11");
                    break;
                }
                case ARQUIVO_PFX: {
                    this.logger.fine("Chave Local");
                    ks = KeyStore.getInstance("PKCS12");
                    FileInputStream in = new FileInputStream(this.getParam().getPathChave());
                    ks.load(in, pass.toCharArray());
                    in.close();
                }
            }
            Enumeration<String> en = ks.aliases();
            while (en.hasMoreElements()) {
                String alias = en.nextElement();
                this.logger.fine("Alias = " + alias);
                Key key = ks.getKey(alias, pass.toCharArray());
                if (!(key instanceof PrivateKey)) continue;
                this.chavePrivada = (PrivateKey)key;
                this.cert = (X509Certificate)ks.getCertificate(alias);
            }
        }
        catch (KeyStoreException kse) {
            throw new Exception("Erro ao carregar o certificado." + kse.getMessage());
        }
        catch (FileNotFoundException fne) {
            throw new Exception("Arquivo n\u00c3\u00a3o encontrado." + fne.getMessage());
        }
        catch (IOException ioe) {
            throw new Exception("Erro." + ioe.getMessage());
        }
    }

    private synchronized String gerarAssinatura(String xml, String referencia, String referenciaAssinatura) throws Exception {
        try {
            String providerName = System.getProperty("jsr105Provider", "org.jcp.xml.dsig.internal.dom.XMLDSigRI");
            XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName(providerName).newInstance());
            this.logger.fine("Refer\u00c3\u00aancia = " + referencia);
            ArrayList<Transform> transformList = new ArrayList<Transform>();
            Transform tr1 = fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null);
            Transform tr2 = fac.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (TransformParameterSpec)null);
            transformList.add(tr1);
            transformList.add(tr2);
            Reference ref = null;
            ref = referencia != null ? fac.newReference(new String("#" + referencia), fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), transformList, null, null) : fac.newReference("", fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), transformList, null, null);
            SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(ref));
            KeyInfoFactory kif = fac.getKeyInfoFactory();
            X509Data x509 = kif.newX509Data(Collections.singletonList(this.cert));
            KeyInfo ki = kif.newKeyInfo(Collections.singletonList(x509));
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
            Document doc = dbf.newDocumentBuilder().parse(is);
            if (referencia != null && !referencia.isEmpty()) {
                Node element = doc.getDocumentElement().getFirstChild();
                if (element.getNodeType() != 1) {
                    element = element.getNextSibling();
                }
                Element el = (Element)element;
                el.setIdAttribute("Id", true);
            }
            DOMSignContext dsc = new DOMSignContext(this.chavePrivada, (Node)doc.getDocumentElement());
            this.logger.fine("Assinando...");
            XMLSignature signature = fac.newXMLSignature(si, ki, null, referenciaAssinatura, null);
            signature.sign(dsc);
            this.setDigestValue(doc.getDocumentElement().getElementsByTagName("DigestValue").item(0).getTextContent());
            StringWriter fos = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer trans = tf.newTransformer();
            if (this.isOmitirDeclaracao()) {
                trans.setOutputProperty("omit-xml-declaration", "yes");
            } else {
                trans.setOutputProperty("omit-xml-declaration", "false");
            }
            trans.setOutputProperty("standalone", "yes");
            trans.setOutputProperty("indent", "no");
            trans.transform(new DOMSource(doc), new StreamResult(fos));
            return fos.toString().replaceAll("\n|\r|\t", "");
        }
        catch (Exception e) {
            System.out.println("Erro = " + e.getMessage());
            System.out.println("Causa = " + e.getCause());
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    public String assinarByteArray(byte[] obj) {
        try {
            this.obterCertificadoDigital();
            Signature signer = Signature.getInstance("SHA1withRSA");
            signer.initSign(this.chavePrivada);
            signer.update(obj);
            return Base64.getEncoder().encodeToString(signer.sign()).replaceAll("\n|\r|\t", "");
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean isOmitirDeclaracao() {
        return this.omitirDeclaracao;
    }

    public void setOmitirDeclaracao(boolean omitirDeclaracao) {
        this.omitirDeclaracao = omitirDeclaracao;
    }

    public ParametroAssinatura getParam() {
        return this.param;
    }

    public void setParam(ParametroAssinatura param) {
        this.param = param;
    }

    public String getDigestValue() {
        return this.digestValue;
    }

    public void setDigestValue(String digestValue) {
        this.digestValue = digestValue;
    }
}

