/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.integracao.admin.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class CustomJsonFormatte
extends Formatter {
    @Override
    public String format(LogRecord record) {
        ObjectMapper mapper = new ObjectMapper();
        Object msg = record.getMessage();
        if (record.getParameters() != null) {
            Object[] objectArray = record.getParameters();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                msg = (String)msg + " " + obj.toString();
                ++n2;
            }
        }
        LogDTO log = new LogDTO(record.getLevel().getName(), record.getLoggerName(), record.getSourceMethodName(), (String)msg, this.formatarData(record.getInstant()), record.getSequenceNumber());
        String jsonInString = null;
        try {
            jsonInString = mapper.writeValueAsString((Object)log);
        }
        catch (JsonProcessingException ex) {
            Logger.getLogger(CustomJsonFormatte.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (record.getSequenceNumber() == 0L) {
            return "{\"data\":[" + jsonInString;
        }
        return "," + jsonInString;
    }

    public String formatarData(Instant data) {
        String PATTERN_FORMAT = "dd-MM-yyyy hh:mm:ss";
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(PATTERN_FORMAT).withZone(ZoneId.systemDefault());
        return formatter.format(data);
    }

    public class LogDTO {
        public String dataLog;
        public String message;
        public String logLevel;
        public String classe;
        public String metodo;
        public long sequencia;

        public LogDTO(String logLevel, String classe, String metodo, String message, String dataLog, long sequencia) {
            this.logLevel = logLevel;
            this.classe = classe;
            this.metodo = metodo;
            this.message = message;
            this.dataLog = dataLog;
            this.sequencia = sequencia;
        }

        public String getLogLevel() {
            return this.logLevel;
        }

        public void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        public String getClasse() {
            return this.classe;
        }

        public void setClasse(String classe) {
            this.classe = classe;
        }

        public String getMetodo() {
            return this.metodo;
        }

        public void setMetodo(String metodo) {
            this.metodo = metodo;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getData() {
            return this.dataLog;
        }

        public void setData(String data) {
            this.dataLog = data;
        }

        public long getSequencia() {
            return this.sequencia;
        }

        public void setSequencia(long sequencia) {
            this.sequencia = sequencia;
        }
    }
}

