/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.monitor;

import br.com.ophos.enumerations.TipoIntegracao;
import br.com.ophos.enumerations.TipoOBJ;
import br.com.ophos.integracao.admin.config.Parametro;
import br.com.ophos.integracao.admin.config.TipoArmazenamento;
import br.com.ophos.integracao.cte.CteInterface;
import br.com.ophos.integracao.interfaces.nfe.NfeInterface;
import br.com.ophos.integracao.interfaces.nfe.dto.emissao.RetConsultaEnvio;
import br.com.ophos.interfaces.MDFeInterface;
import br.com.ophos.interfaces.NFSeInterface;
import br.com.ophos.monitor.BufferDB;
import br.com.ophos.retorno.ReciboEnvio;
import br.com.ophos.retorno.RetornoCTE;
import br.com.ophos.retorno.RetornoMDFE;
import br.com.ophos.retorno.RetornoNFE;
import br.com.ophos.retorno.RetornoNFSE;
import br.com.ophos.xml.mdfe.consulta.RetConsultaMDFE;
import br.com.ophos.xml.nfse.consulta.v100.RetConsultaNfse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.logging.Logger;

public class ConsumidorRetorno
implements Runnable {
    private String dirSaida;
    private String dirEntrada;
    private BufferDB bRetorno;
    private Integer tRetorno;
    private Parametro paramProperties;
    private MDFeInterface ifaceMdfe;
    private NFSeInterface ifaceNfse;

    public ConsumidorRetorno(BufferDB bufferRetorno, Parametro param) {
        this.dirSaida = param.getDataOut();
        this.dirEntrada = param.getDataIn();
        this.tRetorno = param.getTempoRetorno();
        this.bRetorno = bufferRetorno;
        this.paramProperties = param;
    }

    public ConsumidorRetorno(BufferDB bufferRetorno, String entrada, String saida, Object portNFE, Integer tempoRetorno, TipoIntegracao tpSaida, Parametro param, MDFeInterface ifaceMdfe) {
        this.dirSaida = saida;
        this.dirEntrada = entrada;
        this.bRetorno = bufferRetorno;
        this.tRetorno = tempoRetorno;
        this.paramProperties = param;
        this.ifaceMdfe = ifaceMdfe;
    }

    public ConsumidorRetorno(BufferDB bufferRetorno, String entrada, String saida, Object portNFE, Integer tempoRetorno, TipoIntegracao tpSaida, Parametro param, NFSeInterface ifaceNfse) {
        this.dirSaida = saida;
        this.dirEntrada = entrada;
        this.bRetorno = bufferRetorno;
        this.tRetorno = tempoRetorno;
        this.paramProperties = param;
        this.ifaceNfse = ifaceNfse;
    }

    private String RetornaNomeSemExtensao(String nomeFile) {
        return nomeFile.substring(0, nomeFile.lastIndexOf("."));
    }

    private void DeleteRecFile(String nomeFile) throws IOException {
        String nomeFilein = nomeFile.substring(0, nomeFile.lastIndexOf("."));
        File file = new File(this.dirEntrada + "/" + nomeFilein + ".REC");
        if (!file.delete()) {
            File file2 = new File(this.dirEntrada + "/" + nomeFilein + ".rec");
            file2.delete();
        }
    }

    private void DeleteTmxFile(String nomeFile) throws IOException {
        String nomeFilein = nomeFile.substring(0, nomeFile.lastIndexOf("."));
        File file = new File(this.dirEntrada + "/" + nomeFilein + ".TMX");
        file.delete();
        if (!file.delete()) {
            File file2 = new File(this.dirEntrada + "/" + nomeFilein + ".tmx");
            file2.delete();
        }
    }

    private void DeleteTmpFile(String nomeFile) throws IOException {
        String nomeFilein = nomeFile.substring(0, nomeFile.lastIndexOf("."));
        File file = new File(this.dirEntrada + "/" + nomeFilein + ".TMP");
        boolean arquivoApagado = false;
        arquivoApagado = file.delete();
        if (!file.delete()) {
            File file2 = new File(this.dirEntrada + "/" + nomeFilein + ".tmp");
            arquivoApagado = file2.delete();
        }
    }

    private void DeleteBdkFile(String nomeFile) throws IOException {
        String nomeFilein = nomeFile.substring(0, nomeFile.lastIndexOf("."));
        File file = new File(this.dirEntrada + "/" + nomeFilein + ".BDK");
        file.delete();
        if (!file.delete()) {
            File file2 = new File(this.dirEntrada + "/" + nomeFilein + ".bdk");
            file2.delete();
        }
    }

    private void DeleteSapFile(String nomeFile) throws IOException {
        String nomeFilein = nomeFile.substring(0, nomeFile.lastIndexOf("."));
        File file = new File(this.dirEntrada + "/" + nomeFilein + ".SAP1");
        file.delete();
        File file2 = new File(this.dirEntrada + "/" + nomeFilein + ".SAP2");
        file2.delete();
    }

    private void CriarLCKFile(ReciboEnvio obj) throws IOException {
        String nomeFilein = obj.getNomeArquivo();
        nomeFilein = nomeFilein.substring(0, nomeFilein.lastIndexOf("."));
        FileOutputStream fo = new FileOutputStream(this.dirEntrada + "/" + nomeFilein + ".LCK");
        ObjectOutputStream oo = new ObjectOutputStream(fo);
        oo.writeObject(obj);
        oo.close();
    }

    private void SerializeObjectRecibo(ReciboEnvio obj) throws IOException {
        String nomeFilein = obj.getNomeArquivo();
        nomeFilein = nomeFilein.substring(0, nomeFilein.lastIndexOf("."));
        FileOutputStream fo = new FileOutputStream(this.paramProperties.getPastaArmazenamentoRet() + "/" + nomeFilein + ".REC");
        ObjectOutputStream oo = new ObjectOutputStream(fo);
        oo.writeObject(obj);
        oo.close();
    }

    private void CriarConFile(ReciboEnvio obj) throws IOException {
        String nomeFilein = obj.getNomeArquivo();
        nomeFilein = nomeFilein.substring(0, nomeFilein.lastIndexOf("."));
        FileOutputStream fo = new FileOutputStream(this.dirEntrada + "/" + nomeFilein + ".RCO");
        ObjectOutputStream oo = new ObjectOutputStream(fo);
        oo.writeObject(obj);
        oo.close();
        if (this.paramProperties.getTipoArmazenamentoRet().equals("1")) {
            this.SerializeObjectRecibo(obj);
        }
    }

    private void GeraRetornoNFE(RetConsultaEnvio result, ReciboEnvio itemBuffer) throws IOException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (itemBuffer.getTpIntegracao() == TipoIntegracao.TXT) {
            logger.info(this.paramProperties.getVersaoIntegrador() + " - ID: " + itemBuffer.getId().toString() + " - " + result.getStatus().toString() + " - " + result.getMensagem());
            if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                RetornoNFE.gerarTXT(this.paramProperties.getPastaArmazenamentoRet(), this.RetornaNomeSemExtensao(itemBuffer.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT", result);
            }
            RetornoNFE.gerarTXT(this.dirSaida, this.RetornaNomeSemExtensao(itemBuffer.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT", result);
        }
        if (itemBuffer.getTpIntegracao() == TipoIntegracao.XML || itemBuffer.getTpIntegracao() == TipoIntegracao.XML_SEFAZ) {
            logger.info(this.paramProperties.getVersaoIntegrador() + " - ID: " + itemBuffer.getId().toString() + " - " + result.getStatus().toString() + " - " + result.getMensagem());
            if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                if (itemBuffer.getTpIntegracao() == TipoIntegracao.XML) {
                    RetornoNFE.gerarXML_Integra(this.paramProperties.getPastaArmazenamentoRet(), this.RetornaNomeSemExtensao(itemBuffer.getNomeArquivo().replace('I', 'O')) + ".XML", result, null, result.getChaveAcesso());
                }
                if (itemBuffer.getTpIntegracao() == TipoIntegracao.XML_SEFAZ) {
                    RetornoNFE.gerarXML_SEFAZ(this.paramProperties.getPastaArmazenamentoRet(), this.RetornaNomeSemExtensao(itemBuffer.getNomeArquivo().replace('I', 'O')) + ".XML", result, null, null);
                }
            }
            if (itemBuffer.getTpIntegracao() == TipoIntegracao.XML) {
                RetornoNFE.gerarXML_Integra(this.dirSaida, this.RetornaNomeSemExtensao(itemBuffer.getNomeArquivo().replace('I', 'O')) + ".XML", result, null, result.getChaveAcesso());
            }
            if (itemBuffer.getTpIntegracao() == TipoIntegracao.XML_SEFAZ) {
                RetornoNFE.gerarXML_SEFAZ(this.paramProperties.getDataOut(), this.RetornaNomeSemExtensao(itemBuffer.getNomeArquivo().replace('I', 'O')) + ".XML", result, null, null);
            }
        }
    }

    private void GeraRetornoCTE(br.com.ophos.integracao.interfaces.cte.dto.emissao.RetConsultaEnvio result, ReciboEnvio itemBuffer) throws IOException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (itemBuffer.getTpIntegracao() == TipoIntegracao.TXT) {
            logger.info("ID: " + itemBuffer.getId().toString() + " - " + result.getStatus().toString() + " - " + result.getMensagem());
            RetornoCTE.gerarTxtEnvio(this.dirSaida, this.RetornaNomeSemExtensao(itemBuffer.getNomeArquivo()) + ".TXT", result);
            if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                RetornoCTE.gerarTxtEnvio(this.paramProperties.getPastaArmazenamentoRet(), this.RetornaNomeSemExtensao(itemBuffer.getNomeArquivo()) + ".TXT", result);
            }
        }
        if (itemBuffer.getTpIntegracao() == TipoIntegracao.XML_SEFAZ) {
            logger.info("ID: " + itemBuffer.getId().toString() + " - " + result.getStatus().toString() + " - " + result.getMensagem());
            RetornoCTE.gerarXML_SEFAZ(this.dirSaida, this.RetornaNomeSemExtensao(itemBuffer.getNomeArquivo()) + ".XML", null, result);
            if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                RetornoCTE.gerarXML_SEFAZ(this.dirSaida, this.RetornaNomeSemExtensao(itemBuffer.getNomeArquivo()) + ".XML", null, result);
            }
        }
    }

    private void GeraRetornoCTEOS(br.com.ophos.integracao.interfaces.cte.dto.emissao.RetConsultaEnvio result, ReciboEnvio itemBuffer) throws IOException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (itemBuffer.getTpIntegracao() == TipoIntegracao.TXT) {
            logger.info("ID: " + itemBuffer.getId().toString() + " - " + result.getStatus().toString() + " - " + result.getMensagem());
            RetornoCTE.gerarTxtEnvio(this.dirSaida, this.RetornaNomeSemExtensao(itemBuffer.getNomeArquivo()) + ".TXT", result);
            if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                RetornoCTE.gerarTxtEnvio(this.paramProperties.getPastaArmazenamentoRet(), this.RetornaNomeSemExtensao(itemBuffer.getNomeArquivo()) + ".TXT", result);
            }
        }
        if (itemBuffer.getTpIntegracao() == TipoIntegracao.XML_SEFAZ) {
            logger.info("ID: " + itemBuffer.getId().toString() + " - " + result.getStatus().toString() + " - " + result.getMensagem());
            RetornoCTE.gerarXML_SEFAZ(this.dirSaida, this.RetornaNomeSemExtensao(itemBuffer.getNomeArquivo()) + ".XML", null, result);
            if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                RetornoCTE.gerarXML_SEFAZ(this.dirSaida, this.RetornaNomeSemExtensao(itemBuffer.getNomeArquivo()) + ".XML", null, result);
            }
        }
    }

    private void GeraRetornoMDFE(RetConsultaMDFE result, ReciboEnvio itemBuffer) throws IOException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (itemBuffer.getTpIntegracao() == TipoIntegracao.TXT) {
            logger.info("ID: " + itemBuffer.getId().toString() + " - " + result.getStatus().toString() + " - " + result.getMensagem());
            RetornoMDFE.gerarRetornoEnvio(this.dirSaida, this.RetornaNomeSemExtensao(itemBuffer.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT", result);
            if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                RetornoMDFE.gerarRetornoEnvio(this.paramProperties.getPastaArmazenamentoRet(), this.RetornaNomeSemExtensao(itemBuffer.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT", result);
            }
        }
    }

    private void GeraRetornoNFSE(RetConsultaNfse result, ReciboEnvio itemBuffer) throws IOException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (itemBuffer.getTpIntegracao() == TipoIntegracao.TXT) {
            logger.info("ID: " + itemBuffer.getId().toString() + " - " + String.valueOf(result.getStatus()) + " - " + result.getMensagem());
            RetornoNFSE.gerarRetornoEnvio(this.dirSaida, this.RetornaNomeSemExtensao(itemBuffer.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT", result);
            if (this.paramProperties.getTipoArmazenamentoRet().equals((Object)TipoArmazenamento.SEMPRE)) {
                RetornoNFSE.gerarRetornoEnvio(this.paramProperties.getPastaArmazenamentoRet(), this.RetornaNomeSemExtensao(itemBuffer.getNomeArquivo().toUpperCase().replace('I', 'O')) + ".TXT", result);
            }
        }
    }

    @Override
    public void run() {
        Logger logger = Logger.getLogger(this.getClass().getName());
        while (true) {
            ReciboEnvio itemBuffer = null;
            try {
                itemBuffer = (ReciboEnvio)this.bRetorno.Get();
                Object result = null;
                String statusWS = "";
                String msgRet = "";
                if (itemBuffer.getTpOBJ() == TipoOBJ.NFE) {
                    result = NfeInterface.obterRetornoEnvio(this.paramProperties.getUrlbase(), this.paramProperties.getToken(), itemBuffer.getId().toString());
                    statusWS = ((RetConsultaEnvio)result).getStatus().toString();
                    msgRet = ((RetConsultaEnvio)result).getMensagem();
                }
                if (itemBuffer.getTpOBJ() == TipoOBJ.CTE) {
                    result = CteInterface.obterRetornoEnvio(this.paramProperties.getUrlbase(), this.paramProperties.getToken(), itemBuffer.getId().toString());
                    statusWS = ((br.com.ophos.integracao.interfaces.cte.dto.emissao.RetConsultaEnvio)result).getStatus().toString();
                    msgRet = ((br.com.ophos.integracao.interfaces.cte.dto.emissao.RetConsultaEnvio)result).getMensagem();
                }
                if (itemBuffer.getTpOBJ() == TipoOBJ.CTEOS) {
                    result = CteInterface.obterRetornoEnvio(this.paramProperties.getUrlbase(), this.paramProperties.getToken(), itemBuffer.getId().toString());
                    statusWS = ((br.com.ophos.integracao.interfaces.cte.dto.emissao.RetConsultaEnvio)result).getStatus().toString();
                    msgRet = ((br.com.ophos.integracao.interfaces.cte.dto.emissao.RetConsultaEnvio)result).getMensagem();
                }
                if (itemBuffer.getTpOBJ() == TipoOBJ.MDFE) {
                    result = this.ifaceMdfe.retornoConsultaMdfe(itemBuffer.getCnpj(), itemBuffer.getNumero(), itemBuffer.getSerie());
                    statusWS = ((RetConsultaMDFE)result).getStatus().toString();
                    msgRet = ((RetConsultaMDFE)result).getMensagem();
                }
                if (itemBuffer.getTpOBJ() == TipoOBJ.NFSE) {
                    result = this.ifaceNfse.retornoConsultaNfse(itemBuffer.getCnpj(), itemBuffer.getNumero(), itemBuffer.getSerie());
                    statusWS = String.valueOf(((RetConsultaNfse)result).getStatus());
                    msgRet = ((RetConsultaNfse)result).getMensagem();
                }
                if (statusWS.equals("EM_PROCESSAMENTO") || statusWS.equals("501")) {
                    logger.info(this.paramProperties.getVersaoIntegrador() + " - ID: " + itemBuffer.getId().toString() + " - " + statusWS + " - " + msgRet);
                    if (!this.bRetorno.Offer(itemBuffer).booleanValue()) {
                        this.CriarLCKFile(itemBuffer);
                    }
                } else {
                    if (itemBuffer.getTpOBJ() == TipoOBJ.NFE) {
                        this.GeraRetornoNFE((RetConsultaEnvio)result, itemBuffer);
                    }
                    if (itemBuffer.getTpOBJ() == TipoOBJ.CTE) {
                        this.GeraRetornoCTE((br.com.ophos.integracao.interfaces.cte.dto.emissao.RetConsultaEnvio)result, itemBuffer);
                    }
                    if (itemBuffer.getTpOBJ() == TipoOBJ.CTEOS) {
                        this.GeraRetornoCTEOS((br.com.ophos.integracao.interfaces.cte.dto.emissao.RetConsultaEnvio)result, itemBuffer);
                    }
                    if (itemBuffer.getTpOBJ() == TipoOBJ.MDFE) {
                        this.GeraRetornoMDFE((RetConsultaMDFE)result, itemBuffer);
                    }
                    if (itemBuffer.getTpOBJ() == TipoOBJ.NFSE) {
                        this.GeraRetornoNFSE((RetConsultaNfse)result, itemBuffer);
                    }
                    if (statusWS.equals("CONTINGENCIA_ENVIO") || statusWS.equals("502")) {
                        this.CriarConFile(itemBuffer);
                    } else if (statusWS.equals("CONTINGENCIA_RETORNO")) {
                        this.CriarConFile(itemBuffer);
                    } else if (statusWS.equals("EM_CONTINGENCIA_RETORNO")) {
                        this.CriarConFile(itemBuffer);
                    } else if (statusWS.equals("EM_CONTINGENCIA_ENVIO")) {
                        this.CriarConFile(itemBuffer);
                    } else if (statusWS.equals("ERRO_GERAL") || statusWS.equals("999")) {
                        if (!this.paramProperties.getGeraErroRetorno().booleanValue()) {
                            this.CriarConFile(itemBuffer);
                        } else {
                            this.DeleteRecFile(itemBuffer.getNomeArquivo());
                            if (itemBuffer.getNomeArquivo().toLowerCase().endsWith(".xml")) {
                                this.DeleteTmxFile(itemBuffer.getNomeArquivo());
                            }
                            if (itemBuffer.getNomeArquivo().toLowerCase().endsWith(".txt")) {
                                this.DeleteTmpFile(itemBuffer.getNomeArquivo());
                            }
                            if (itemBuffer.getNomeArquivo().toLowerCase().endsWith(".bd")) {
                                this.DeleteBdkFile(itemBuffer.getNomeArquivo());
                            }
                            if (itemBuffer.getNomeArquivo().toLowerCase().endsWith(".sap1")) {
                                this.DeleteSapFile(itemBuffer.getNomeArquivo());
                            }
                            logger.info(this.paramProperties.getVersaoIntegrador() + " - ID: " + itemBuffer.getId().toString() + " apagado.");
                        }
                    } else {
                        this.DeleteRecFile(itemBuffer.getNomeArquivo());
                        if (itemBuffer.getNomeArquivo().toLowerCase().endsWith(".xml")) {
                            this.DeleteTmxFile(itemBuffer.getNomeArquivo());
                        }
                        if (itemBuffer.getNomeArquivo().toLowerCase().endsWith(".txt")) {
                            this.DeleteTmpFile(itemBuffer.getNomeArquivo());
                        }
                        if (itemBuffer.getNomeArquivo().toLowerCase().endsWith(".bd")) {
                            this.DeleteBdkFile(itemBuffer.getNomeArquivo());
                        }
                        if (itemBuffer.getNomeArquivo().toLowerCase().endsWith(".sap1")) {
                            this.DeleteSapFile(itemBuffer.getNomeArquivo());
                        }
                        logger.info(this.paramProperties.getVersaoIntegrador() + " - ID: " + itemBuffer.getId().toString() + " apagado.");
                    }
                }
            }
            catch (IOException ex) {
                logger.severe(this.paramProperties.getVersaoIntegrador() + " - N\u00e3o foi poss\u00edvel apagar o ID " + itemBuffer.getId().toString() + " Erro: " + ex.getMessage());
            }
            catch (Exception ex) {
                logger.severe(this.paramProperties.getVersaoIntegrador() + " - N\u00e3o foi poss\u00edvel obter o retorno do ID: " + itemBuffer.getId().toString() + " Erro: " + ex.getMessage());
            }
            try {
                if (this.tRetorno == 0) continue;
                Thread.sleep(this.tRetorno.intValue());
            }
            catch (Exception exception) {
            }
        }
    }
}

