/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.parse.txt.mdfe.v1;

import br.com.ophos.enumerations.TipoEvento;
import br.com.ophos.parse.ParseException;
import br.com.ophos.parse.txt.mdfe.v1.ParseTXTEventoMDFEv101;
import br.com.ophos.parse.util.Scanner;
import br.com.ophos.util.nfe.Util;
import br.com.ophos.xml.mdfe.envio.InfoPagamento;
import br.com.ophos.xml.mdfe.evento.EventoMDFE;
import br.com.ophos.xml.mdfe.evento.EventoPagamento;
import java.io.InputStream;

public class ParseTXTEventoMDFEv102
extends ParseTXTEventoMDFEv101 {
    private EventoMDFE obj = null;
    private static ParseTXTEventoMDFEv102 instance;

    public static ParseTXTEventoMDFEv102 getInstance() {
        if (instance == null) {
            instance = new ParseTXTEventoMDFEv102();
        }
        return instance;
    }

    @Override
    public EventoMDFE parse(InputStream is) throws ParseException {
        try (Scanner scanner = null;){
            scanner = new Scanner(is);
            scanner.nextLine();
            while (scanner.hasNextLine()) {
                String linha = scanner.nextLine();
                this.lerLinhaEvento(linha + "|");
            }
        }
        return this.obj;
    }

    private void lerLinhaEvento(String linha) throws ParseException {
        Integer ID = Integer.parseInt(linha.substring(1, 3));
        switch (ID) {
            case 0: {
                this.dadosEvento(linha);
                break;
            }
            case 1: {
                this.dadosEventoPagamento(linha);
                break;
            }
            case 2: {
                this.dadosPagamento(linha);
                break;
            }
            case 3: {
                this.dadosComponenteFrete(linha);
                break;
            }
            case 4: {
                this.dadosParcelaFrete(linha);
                break;
            }
            default: {
                throw new ParseException("O identificador '" + String.valueOf(ID) + "'da linha informado n\u00e3o foi encontrado.");
            }
        }
    }

    protected void dadosEvento(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 7) {
                throw new ParseException("A linha 000 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 7 campos.");
            }
            this.obj = new EventoMDFE();
            while (scanner.hasNext()) {
                scanner.next();
                switch (scanner.next()) {
                    case "1": {
                        this.obj.setTipoEvento(TipoEvento.CANCELAMENTO);
                        this.obj.setChaveAcesso(scanner.next());
                        this.obj.setJustificativa(scanner.next());
                        scanner.next();
                        scanner.next();
                        scanner.next();
                        scanner.next();
                        break;
                    }
                    case "2": {
                        this.obj.setTipoEvento(TipoEvento.ENCERRAMENTO);
                        this.obj.setChaveAcesso(scanner.next());
                        scanner.next();
                        this.obj.setDataEncerramento(br.com.ophos.util.Util.parseData(scanner.next(), br.com.ophos.util.Util.FMTYYYYMMDD_2));
                        this.obj.setNrIbge(scanner.next());
                        this.obj.setMunicipio(scanner.next());
                        this.obj.setUf(scanner.next());
                        break;
                    }
                    case "3": {
                        this.obj.setTipoEvento(TipoEvento.PAGAMENTO);
                        this.obj.setChaveAcesso(scanner.next());
                        this.obj.setEvento(new EventoPagamento());
                        this.obj.getEvento().setChaveAcesso(this.obj.getChaveAcesso());
                        scanner.next();
                        scanner.next();
                        scanner.next();
                        scanner.next();
                        scanner.next();
                        break;
                    }
                    default: {
                        throw new ParseException("N\u00e3o foi informado o tipo de evento.");
                    }
                }
            }
            scanner.close();
        }
        catch (ParseException ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 000: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dadosEventoPagamento(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 2) {
                throw new ParseException("A linha 001 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 2 campo.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                EventoPagamento e = (EventoPagamento)this.obj.getEvento();
                e.setQuantidadeViagem(Util.StringToInteger(scanner.next()));
                e.setNrReferenciaViagem(Util.StringToInteger(scanner.next()));
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 001: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dadosPagamento(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 8) {
                throw new ParseException("A linha 002 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 8 campo.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                InfoPagamento pag = new InfoPagamento();
                pag.setId(scanner.next());
                pag.setCnpjCpf(scanner.next());
                pag.setNome(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                pag.setValorContrato(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                pag.setFormaPagamento(scanner.next());
                pag.setBanco(new InfoPagamento.InfoBanco());
                pag.getBanco().setBanco(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                pag.getBanco().setAgencia(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                pag.getBanco().setCnpjIpef(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                EventoPagamento e = (EventoPagamento)this.obj.getEvento();
                e.getInfoPagamento().add(pag);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 002: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dadosComponenteFrete(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 4) {
                throw new ParseException("A linha 003 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 4 campo.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                InfoPagamento pgto = this.getPgto(scanner.next());
                InfoPagamento.Componente comp = new InfoPagamento.Componente();
                comp.setTipo(scanner.next());
                comp.setDescricao(br.com.ophos.util.Util.checkIsNullEmpty(scanner.next()));
                comp.setValor(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                pgto.getComponentes().add(comp);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 003: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dadosParcelaFrete(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            if (qtdCampos != 4) {
                throw new ParseException("A linha 004 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado 4 campo.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                InfoPagamento pgto = this.getPgto(scanner.next());
                InfoPagamento.InfoParcela parcela = new InfoPagamento.InfoParcela();
                parcela.setNumero(scanner.next());
                parcela.setVencimento(Util.StringToXMLCalendar(scanner.next()));
                parcela.setValor(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                pgto.getParcelas().add(parcela);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 004: " + ex.getMessage());
        }
    }

    protected InfoPagamento getPgto(String id) throws ParseException {
        EventoPagamento e = (EventoPagamento)this.obj.getEvento();
        for (InfoPagamento o : e.getInfoPagamento()) {
            if (!id.equals(o.getId())) continue;
            return o;
        }
        throw new ParseException("O identificador do pagamento informado n\u00e3o foi localizado.");
    }
}

