/*
 * Decompiled with CFR 0.152.
 */
package br.com.ophos.parse.txt.nfse.v1;

import br.com.ophos.parse.ParseException;
import br.com.ophos.parse.ParseException2;
import br.com.ophos.parse.txt.nfse.v1.ParseTXTEnvioNFSEV105;
import br.com.ophos.parse.util.Scanner;
import br.com.ophos.util.nfe.Util;
import br.com.ophos.xml.nfse.envio.v100.ConstrucaoCivil;
import br.com.ophos.xml.nfse.envio.v100.Destinatario;
import br.com.ophos.xml.nfse.envio.v100.Intermediario;
import br.com.ophos.xml.nfse.envio.v100.Prestador;
import br.com.ophos.xml.nfse.envio.v100.Rps;
import br.com.ophos.xml.nfse.envio.v100.RpsSubstituido;
import br.com.ophos.xml.nfse.envio.v100.Servico;
import br.com.ophos.xml.nfse.envio.v100.Tomador;
import br.com.ophos.xml.nfse.envio.v100.Totais;
import br.com.ophos.xml.nfse.envio.v100.Tributos;
import java.io.InputStream;
import java.util.ArrayList;

public class ParseTXTEnvioNFSEV106
extends ParseTXTEnvioNFSEV105 {
    private static ParseTXTEnvioNFSEV106 instance;

    public static ParseTXTEnvioNFSEV106 getInstance() {
        if (instance == null) {
            instance = new ParseTXTEnvioNFSEV106();
        }
        return instance;
    }

    @Override
    public Rps parse(InputStream is) throws ParseException2 {
        this.obj = new Rps();
        try (Scanner scanner = null;){
            ArrayList<Integer> linhasObrigatorias = new ArrayList<Integer>();
            linhasObrigatorias.add(0);
            linhasObrigatorias.add(1);
            linhasObrigatorias.add(2);
            linhasObrigatorias.add(3);
            linhasObrigatorias.add(4);
            linhasObrigatorias.add(9);
            linhasObrigatorias.add(10);
            linhasObrigatorias.add(11);
            ArrayList<Integer> linhasErro = new ArrayList<Integer>();
            ArrayList<Integer> linhasEncontradas = new ArrayList<Integer>();
            scanner = new Scanner(is);
            scanner.next();
            while (scanner.hasNextLine()) {
                String linha = null;
                linha = scanner.nextLine();
                if (linha.length() < 3) continue;
                Integer n = Integer.parseInt(linha.substring(1, 3));
                linhasEncontradas.add(n);
                try {
                    this.lerLinhaRps(linha + "|");
                }
                catch (ParseException paex) {
                    linhasErro.add(n);
                }
            }
            Object msgException = "";
            for (Object e : linhasErro) {
                msgException = (String)msgException + String.valueOf(e);
            }
            if (linhasErro.size() > 0) {
                throw new ParseException2("ERRO_LAYOUT: " + (String)msgException, this.obj);
            }
            for (Object e : linhasObrigatorias) {
                Integer id = (Integer)e;
                if (linhasEncontradas.contains(id)) continue;
                throw new ParseException2("Linha obrigat\u00f3ria: " + e.toString() + " n\u00e3o encontrada no arquivo texto.");
            }
        }
        return this.obj;
    }

    private void lerLinhaRps(String linha) throws ParseException {
        Integer ID = Integer.parseInt(linha.substring(1, 3));
        switch (ID) {
            case 0: {
                this.dadosRps(linha);
                break;
            }
            case 1: {
                this.dadosPrestador(linha);
                break;
            }
            case 2: {
                this.dadosTomador(linha);
                break;
            }
            case 3: {
                this.dadosServico(linha);
                break;
            }
            case 4: {
                this.dadosTotais(linha);
                break;
            }
            case 5: {
                this.dadosIntermediario(linha);
                break;
            }
            case 7: {
                this.dadosConstrucaoCivil(linha);
                break;
            }
            case 8: {
                this.dadosDestinatario(linha);
                break;
            }
            case 9: {
                this.dadosTributos(linha);
                break;
            }
            case 10: {
                this.dadosIbsCbs(linha);
                break;
            }
            case 11: {
                this.dadosLeiTransparenciaFiscal(linha);
                break;
            }
            default: {
                throw new ParseException("O identificador '" + String.valueOf(ID) + "'da linha informado n\u00e3o foi encontrado.");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dadosRps(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            Integer qtdEsperada = 9;
            if (qtdCampos != qtdEsperada) {
                throw new ParseException("A linha 000 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + String.valueOf(qtdEsperada) + " campos.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                this.obj.setNumero(Integer.parseInt(scanner.next()));
                this.obj.setSerie(scanner.next());
                this.obj.setTipo(Integer.parseInt(scanner.next()));
                this.obj.setDataEmissao(Util.StringToDateTime(scanner.next()));
                this.obj.setCompetencia(Util.StringToDate(scanner.next()));
                this.obj.setNaturezaOperacao(Integer.parseInt(scanner.next()));
                this.obj.setSituacao(Integer.parseInt(scanner.next()));
                this.obj.setOutrasInformacoes(scanner.next());
                String chaveAcessoSubstituto = scanner.next();
                if (chaveAcessoSubstituto == null || chaveAcessoSubstituto.trim().isEmpty()) continue;
                this.obj.setSubstituicao(new RpsSubstituido());
                this.obj.getSubstituicao().setChaveAcesso(chaveAcessoSubstituto);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 000: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dadosPrestador(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            Integer qtdEsperada = 6;
            if (qtdCampos != qtdEsperada) {
                throw new ParseException("A linha 001 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + String.valueOf(qtdEsperada) + " campos.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                if (this.obj.getPrestador() == null) {
                    this.obj.setPrestador(new Prestador());
                }
                this.obj.getPrestador().setCnpj(scanner.next());
                this.obj.getPrestador().setInscricaoMunicipal(scanner.next());
                this.obj.getPrestador().setRegimeEspecial(Integer.parseInt(scanner.next()));
                this.obj.getPrestador().setOpcaoSimplesNacional(scanner.next());
                String regimeSimplesNacional = scanner.next();
                if (regimeSimplesNacional != null && !regimeSimplesNacional.isBlank()) {
                    this.obj.getPrestador().setRegimeSimplesNacional(regimeSimplesNacional);
                }
                this.obj.getPrestador().setIncentivadorCultural(Integer.parseInt(scanner.next()));
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 001: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dadosTomador(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            Integer qtdEsperada = 16;
            if (qtdCampos != qtdEsperada) {
                throw new ParseException("A linha 002 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + String.valueOf(qtdEsperada) + " campos.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                if (this.obj.getTomador() == null) {
                    this.obj.setTomador(new Tomador());
                }
                String cpfCnpj = scanner.next();
                String inscricaoMunicipal = scanner.next();
                String nome = scanner.next();
                String logradouro = scanner.next();
                String numero = scanner.next();
                String complemento = scanner.next();
                String bairro = scanner.next();
                String municipio = scanner.next();
                String numeroIBGE = scanner.next();
                String uf = scanner.next();
                String cep = scanner.next();
                String telefone = scanner.next();
                String email = scanner.next();
                String tipoLogradouro = scanner.next();
                String inscricaoEstadual = scanner.next();
                String indicadorDestinatario = scanner.next();
                this.obj.getTomador().setCpfCnpj(cpfCnpj);
                if (inscricaoMunicipal != null && !inscricaoMunicipal.trim().isEmpty()) {
                    this.obj.getTomador().setInscricaoMunicipal(inscricaoMunicipal);
                }
                this.obj.getTomador().setNome(nome);
                this.obj.getTomador().setLogradouro(logradouro);
                this.obj.getTomador().setNumero(numero);
                if (complemento != null && !complemento.trim().isEmpty()) {
                    this.obj.getTomador().setComplemento(complemento);
                }
                this.obj.getTomador().setBairro(bairro);
                this.obj.getTomador().setMunicipio(municipio);
                this.obj.getTomador().setNrIbgeMunicipio(numeroIBGE);
                this.obj.getTomador().setUf(uf);
                this.obj.getTomador().setCep(cep);
                if (telefone != null && !telefone.trim().isEmpty()) {
                    this.obj.getTomador().setTelefone(telefone);
                }
                if (email != null && !email.trim().isEmpty()) {
                    this.obj.getTomador().setEmail(email);
                }
                if (tipoLogradouro != null && !tipoLogradouro.trim().isEmpty()) {
                    this.obj.getTomador().setTipoLogradouro(tipoLogradouro);
                }
                if (inscricaoEstadual != null && !inscricaoEstadual.trim().isEmpty()) {
                    this.obj.getTomador().setInscricaoEstadual(inscricaoEstadual);
                }
                this.obj.getTomador().setDestinatario(Util.StringToInteger(indicadorDestinatario));
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 002: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dadosServico(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            Integer qtdEsperada = 8;
            if (!qtdCampos.equals(qtdEsperada)) {
                throw new ParseException("A linha 003 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + String.valueOf(qtdEsperada) + " campos.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    return;
                }
                scanner.next();
                if (this.obj.getServico() == null) {
                    this.obj.setServico(new Servico());
                }
                this.obj.getServico().setCodigoServico(scanner.next());
                String cnae = scanner.next();
                if (cnae != null && !cnae.trim().isEmpty()) {
                    this.obj.getServico().setCodigoCnae(cnae);
                }
                this.obj.getServico().setNbs(scanner.next());
                String codigoTributacao = scanner.next();
                if (codigoTributacao != null && !codigoTributacao.trim().isEmpty()) {
                    this.obj.getServico().setCodigoTributacaoMunicipio(codigoTributacao);
                }
                this.obj.getServico().setDescricao(scanner.next());
                this.obj.getServico().setMunicipio(scanner.next());
                this.obj.getServico().setNrIbgeMunicipio(scanner.next());
                this.obj.getServico().setUf(scanner.next());
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 003: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dadosTotais(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            Integer qtdEsperada = 10;
            if (qtdCampos != qtdEsperada) {
                throw new ParseException("A linha 004 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + String.valueOf(qtdEsperada) + " campos.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                if (this.obj.getTotais() == null) {
                    this.obj.setTotais(new Totais());
                }
                this.obj.getTotais().setValorServicos(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorDeducoes(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorIss(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorIssRetido(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setOutrasRetencoes(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setBaseCalculo(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setAliquota(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setValorLiquidoNfse(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setDescontoIncondicionado(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTotais().setDescontoCondicionado(Util.StringToDouble(scanner.next(), Util.ST_FMT_DOIS_DECIMAIS));
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 004: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dadosIntermediario(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            Integer qtdEsperada = 5;
            if (qtdCampos != qtdEsperada) {
                throw new ParseException("A linha 005 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + String.valueOf(qtdEsperada) + " campos.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                if (this.obj.getIntermediario() == null) {
                    this.obj.setIntermediario(new Intermediario());
                }
                String razaoSocial = scanner.next();
                String cpfCnpj = scanner.next();
                String inscricaoMunicipal = scanner.next();
                String issRetido = scanner.next();
                String email = scanner.next();
                this.obj.getIntermediario().setRazaoSocial(razaoSocial);
                this.obj.getIntermediario().setCpfCnpj(cpfCnpj);
                if (inscricaoMunicipal != null && !inscricaoMunicipal.trim().isEmpty()) {
                    this.obj.getIntermediario().setInscricaoMunicipal(inscricaoMunicipal);
                }
                this.obj.getIntermediario().setIssRetido(Util.StringToInteger(issRetido));
                if (email == null || email.trim().isEmpty()) continue;
                this.obj.getIntermediario().setEmail(email);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 005: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dadosConstrucaoCivil(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            Integer qtdEsperada = 8;
            if (!qtdCampos.equals(qtdEsperada)) {
                throw new ParseException("A linha 007 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + String.valueOf(qtdEsperada) + " campos.");
            }
            while (true) {
                String cib;
                String codigoObra;
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                ConstrucaoCivil construcao = new ConstrucaoCivil();
                String art = scanner.next();
                if (art != null && !art.isBlank()) {
                    construcao.setArt(art);
                }
                if ((codigoObra = scanner.next()) != null && !codigoObra.isBlank()) {
                    construcao.setCodigoObra(codigoObra);
                }
                if ((cib = scanner.next()) != null && !cib.isBlank()) {
                    construcao.setCib(cib);
                }
                String logradouro = scanner.next();
                String numero = scanner.next();
                String complemento = scanner.next();
                String bairro = scanner.next();
                String cep = scanner.next();
                if (logradouro != null && !logradouro.isBlank()) {
                    construcao.setLogradouro(logradouro);
                    construcao.setNumero(numero);
                    if (complemento != null && !complemento.isBlank()) {
                        construcao.setComplemento(complemento);
                    }
                    construcao.setBairro(bairro);
                    construcao.setCep(cep);
                }
                this.obj.setConstrucao(construcao);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 007: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dadosDestinatario(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            Integer qtdEsperada = 12;
            if (qtdCampos != qtdEsperada) {
                throw new ParseException("A linha 008 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + qtdEsperada.toString() + " campos.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                if (this.obj.getDestinatario() == null) {
                    this.obj.setDestinatario(new Destinatario());
                }
                String cpfCnpj = scanner.next();
                String nome = scanner.next();
                String logradouro = scanner.next();
                String numero = scanner.next();
                String complemento = scanner.next();
                String bairro = scanner.next();
                String municipio = scanner.next();
                String nrIbgeMun = scanner.next();
                String uf = scanner.next();
                String cep = scanner.next();
                String telefone = scanner.next();
                String email = scanner.next();
                this.obj.getDestinatario().setCpfCnpj(cpfCnpj);
                this.obj.getDestinatario().setNome(nome);
                this.obj.getDestinatario().setLogradouro(logradouro);
                this.obj.getDestinatario().setNumero(numero);
                if (complemento != null && !complemento.isBlank()) {
                    this.obj.getDestinatario().setComplemento(complemento);
                }
                this.obj.getDestinatario().setBairro(bairro);
                this.obj.getDestinatario().setMunicipio(municipio);
                this.obj.getDestinatario().setNrIbgeMunicipio(nrIbgeMun);
                this.obj.getDestinatario().setUf(uf);
                this.obj.getDestinatario().setCep(cep);
                if (telefone != null && !telefone.isBlank()) {
                    this.obj.getDestinatario().setTelefone(telefone);
                }
                if (email == null || email.isBlank()) continue;
                this.obj.getDestinatario().setEmail(email);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 008: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dadosTributos(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            Integer qtdEsperada = 12;
            if (qtdCampos != qtdEsperada) {
                throw new ParseException("A linha 009 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado: " + qtdEsperada.toString() + " campos.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                if (this.obj.getTributos() == null) {
                    this.obj.setTributos(new Tributos());
                }
                String tipoTributacaoIssqn = scanner.next();
                String tipoImunidade = scanner.next();
                String tipoRetencaoIssqn = scanner.next();
                if (tipoTributacaoIssqn != null && !tipoTributacaoIssqn.isBlank()) {
                    Tributos.Municipal municipal = new Tributos.Municipal();
                    municipal.setTributacao(Util.StringToInteger(tipoTributacaoIssqn));
                    if (tipoImunidade != null && !tipoImunidade.isBlank()) {
                        municipal.setImunidade(Util.StringToInteger(tipoImunidade));
                    }
                    municipal.setRetencao(Util.StringToInteger(tipoRetencaoIssqn));
                    this.obj.getTributos().setMunicipal(municipal);
                }
                String valorInss = scanner.next();
                String valorIr = scanner.next();
                String valorCsll = scanner.next();
                String situacaoPisCofins = scanner.next();
                String baseCalculo = scanner.next();
                String aliquotaPis = scanner.next();
                String valorPis = scanner.next();
                String aliquotaCofins = scanner.next();
                String valorCofins = scanner.next();
                boolean compoeFederal = valorInss != null && !valorInss.isBlank() || valorIr != null && !valorIr.isBlank() || valorCsll != null && !valorCsll.isBlank() || situacaoPisCofins != null && !situacaoPisCofins.isBlank();
                if (!compoeFederal) continue;
                Tributos.Federal federal = new Tributos.Federal();
                if (valorInss != null && !valorInss.isBlank()) {
                    federal.setValorInss(Util.StringToDouble(valorInss, Util.ST_FMT_DOIS_DECIMAIS));
                }
                if (valorIr != null && !valorIr.isBlank()) {
                    federal.setValorIr(Util.StringToDouble(valorIr, Util.ST_FMT_DOIS_DECIMAIS));
                }
                if (valorCsll != null && !valorCsll.isBlank()) {
                    federal.setValorCsll(Util.StringToDouble(valorCsll, Util.ST_FMT_DOIS_DECIMAIS));
                }
                if (situacaoPisCofins != null && !situacaoPisCofins.isBlank()) {
                    Tributos.PisCofins pisCofins = new Tributos.PisCofins();
                    pisCofins.setSituacaoPisCofins(situacaoPisCofins);
                    if (baseCalculo != null && !baseCalculo.isBlank()) {
                        pisCofins.setBaseCalculoPisCofins(Util.StringToDouble(baseCalculo, Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    if (aliquotaPis != null && !aliquotaPis.isBlank()) {
                        pisCofins.setAliquotaPis(Util.StringToDouble(aliquotaPis, Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    if (valorPis != null && !valorPis.isBlank()) {
                        pisCofins.setValorPis(Util.StringToDouble(valorPis, Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    if (aliquotaCofins != null && !aliquotaCofins.isBlank()) {
                        pisCofins.setAliquotaCofins(Util.StringToDouble(aliquotaCofins, Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    if (valorCofins != null && !valorCofins.isBlank()) {
                        pisCofins.setValorCofins(Util.StringToDouble(valorCofins, Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    federal.setPisCofins(pisCofins);
                }
                this.obj.getTributos().setFederal(federal);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 009: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dadosIbsCbs(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            Integer qtdEsperada = 12;
            if (qtdCampos != qtdEsperada) {
                throw new ParseException("A linha 010 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + String.valueOf(qtdEsperada) + " campos.");
            }
            while (true) {
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                if (this.obj.getTributos().getIbsCbs() == null) {
                    this.obj.getTributos().setIbsCbs(new Tributos.IBSCBS());
                }
                String situacaoTributariaIbsCbs = scanner.next();
                String classificaoTributaria = scanner.next();
                String creditoPresumiso = scanner.next();
                String indicaConsumoFinal = scanner.next();
                String codigoOperacao = scanner.next();
                String tpOperacaoGoverno = scanner.next();
                String tpEnteGovernamental = scanner.next();
                this.obj.getTributos().getIbsCbs().setSituacaoTributaria(situacaoTributariaIbsCbs);
                this.obj.getTributos().getIbsCbs().setClassificacaoTributaria(classificaoTributaria);
                if (creditoPresumiso != null && !creditoPresumiso.isBlank()) {
                    this.obj.getTributos().getIbsCbs().setCreditoPresumido(creditoPresumiso);
                }
                this.obj.getTributos().getIbsCbs().setConsumoFinal(Util.StringToInteger(indicaConsumoFinal));
                this.obj.getTributos().getIbsCbs().setCodigoOperacao(codigoOperacao);
                if (tpOperacaoGoverno != null && !tpOperacaoGoverno.isBlank()) {
                    this.obj.getTributos().getIbsCbs().setTipoOperacaoGoverno(Util.StringToInteger(tpOperacaoGoverno));
                }
                if (tpEnteGovernamental != null && !tpEnteGovernamental.isBlank()) {
                    this.obj.getTributos().getIbsCbs().setTipoEnteGoverno(Util.StringToInteger(tpEnteGovernamental));
                }
                String situacaoTributariaTribRegular = scanner.next();
                String classTributariaTribRegular = scanner.next();
                if (situacaoTributariaTribRegular != null && !situacaoTributariaTribRegular.isBlank()) {
                    Tributos.TributacaoRegular tributacaoRegular = new Tributos.TributacaoRegular();
                    tributacaoRegular.setSituacaoTributaria(situacaoTributariaTribRegular);
                    tributacaoRegular.setClassificacaoTributaria(classTributariaTribRegular);
                    this.obj.getTributos().getIbsCbs().setTributacaoRegular(tributacaoRegular);
                }
                String percentualIbsUf = scanner.next();
                String percentualIbsMun = scanner.next();
                String percentualCbs = scanner.next();
                if (percentualIbsUf == null || percentualIbsUf.isBlank()) continue;
                Tributos.Diferimento diferimento = new Tributos.Diferimento();
                diferimento.setPercentualEstadual(Util.StringToDouble(percentualIbsUf, Util.ST_FMT_DOIS_DECIMAIS));
                diferimento.setPercentualMunicipal(Util.StringToDouble(percentualIbsMun, Util.ST_FMT_DOIS_DECIMAIS));
                diferimento.setPercentualFederal(Util.StringToDouble(percentualCbs, Util.ST_FMT_DOIS_DECIMAIS));
                this.obj.getTributos().getIbsCbs().setDiferimento(diferimento);
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 010: " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dadosLeiTransparenciaFiscal(String linha) throws ParseException {
        try {
            Scanner scanner = new Scanner(linha);
            scanner.useDelimiter("\\|");
            Integer qtdCampos = Util.GetQtdDelimiter(linha, "|") - 1;
            Integer qtdEsperada = 10;
            if (qtdCampos != qtdEsperada) {
                throw new ParseException("A linha 011 possui: " + qtdCampos.toString() + " campos, mas \u00e9 esperado " + String.valueOf(qtdEsperada) + " campos.");
            }
            while (true) {
                String percentualSimples;
                boolean compoePercentual;
                boolean compoeValorTotal;
                String fonteTributacao;
                if (!scanner.hasNext()) {
                    scanner.close();
                    return;
                }
                scanner.next();
                if (this.obj.getTributos().getTributosAproximados() == null) {
                    this.obj.getTributos().setTributosAproximados(new Tributos.Transparencia());
                }
                if ((fonteTributacao = scanner.next()) != null && !fonteTributacao.isBlank()) {
                    this.obj.getTributos().getTributosAproximados().setFonteTributacao(fonteTributacao);
                }
                String valorTotFederal = scanner.next();
                String valorTotEstadual = scanner.next();
                String valorTotMunicipal = scanner.next();
                String valorTotal = scanner.next();
                boolean bl = compoeValorTotal = valorTotFederal != null && !valorTotFederal.isBlank() || valorTotEstadual != null && !valorTotEstadual.isBlank() || valorTotMunicipal != null && !valorTotMunicipal.isBlank() || valorTotal != null && !valorTotal.isBlank();
                if (compoeValorTotal) {
                    Tributos.VTotalTributo valorTotalAproximado = new Tributos.VTotalTributo();
                    if (valorTotFederal != null && !valorTotFederal.isBlank()) {
                        valorTotalAproximado.setFederal(Util.StringToDouble(valorTotFederal, Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    if (valorTotEstadual != null && !valorTotEstadual.isBlank()) {
                        valorTotalAproximado.setEstadual(Util.StringToDouble(valorTotEstadual, Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    if (valorTotMunicipal != null && !valorTotMunicipal.isBlank()) {
                        valorTotalAproximado.setMunicipal(Util.StringToDouble(valorTotMunicipal, Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    if (valorTotal != null && !valorTotal.isBlank()) {
                        this.obj.getTributos().getTributosAproximados().setValorTributacao(Util.StringToDouble(valorTotal, Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    this.obj.getTributos().getTributosAproximados().setValorTotalTributcao(valorTotalAproximado);
                }
                String percentTotalFederal = scanner.next();
                String percentTotalEstadual = scanner.next();
                String percentTotalMunicipal = scanner.next();
                String percentualTotal = scanner.next();
                boolean bl2 = compoePercentual = percentTotalFederal != null && !percentTotalFederal.isBlank() || percentTotalEstadual != null && !percentTotalEstadual.isBlank() || percentTotalMunicipal != null && !percentTotalMunicipal.isBlank() || percentualTotal != null && !percentualTotal.isBlank();
                if (compoePercentual) {
                    Tributos.PTotalTributo percentual = new Tributos.PTotalTributo();
                    if (percentTotalFederal != null && !percentTotalFederal.isBlank()) {
                        percentual.setFederal(Util.StringToDouble(percentTotalFederal, Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    if (percentTotalEstadual != null && !percentTotalEstadual.isBlank()) {
                        percentual.setEstadual(Util.StringToDouble(percentTotalEstadual, Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    if (percentTotalMunicipal != null && !percentTotalMunicipal.isBlank()) {
                        percentual.setMunicipal(Util.StringToDouble(percentTotalMunicipal, Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    if (percentualTotal != null && !percentualTotal.isBlank()) {
                        this.obj.getTributos().getTributosAproximados().setPercentualTributacao(Util.StringToDouble(percentualTotal, Util.ST_FMT_DOIS_DECIMAIS));
                    }
                    this.obj.getTributos().getTributosAproximados().setPorcentagemTotalTributacao(percentual);
                }
                if ((percentualSimples = scanner.next()) == null || percentualSimples.isBlank()) continue;
                this.obj.getTributos().getTributosAproximados().setPercentualSimplesNacional(Util.StringToDouble(percentualSimples, Util.ST_FMT_DOIS_DECIMAIS));
            }
        }
        catch (Exception ex) {
            throw new ParseException("Ocorreu um erro ao ler a linha ID = 011: " + ex.getMessage());
        }
    }
}

